# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 9
# Experiment: DAxDA, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def gentle_butterfly_whisperer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # This strategy prioritizes mutual harmony and trust-building, with occasional strategic adjustments.
    harmony_index = sum(1 for move in opp_history if move == "C") / len(opp_history) if opp_history else 0.5
    trust_score = sum(1 for move in my_history if move == "C") / len(my_history) if my_history else 0.5
    
    current_round = len(my_history) + 1
    
    # Initial Trust-Building Phase (Rounds 1-3)
    if current_round == 1:
        return "C"
    elif current_round == 2:
        return "C"
    elif current_round == 3:
        return "D"
    
    # Mid-Game Exploitation Phase (Rounds 4-7)
    elif 4 <= current_round <= 7:
        if current_round == 4:
            return "C"
        elif current_round == 5:
            return "D"
        elif current_round == 6:
            if opp_history[-1] == "D":
                return "C"
            else:
                return "D"
        elif current_round == 7:
            return "D"
    
    # Endgame Aggression Phase (Rounds 8-10)
    elif 8 <= current_round <= 10:
        if current_round == 8:
            return "D"
        elif current_round == 9:
            return "C"
        elif current_round == 10:
            return "D"
    
    # Fallback to cooperation if somehow none of the above conditions are met
    return "C"